/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import top.theillusivec4.curios.api.SlotContext;

public class RunningShoesItem
extends CurioItem {
    public RunningShoesItem() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
    }

    private static AttributeModifier getSpeedBonus() {
        double speedMultiplier = (Double)ModConfig.server.runningShoes.speedMultiplier.get();
        return new AttributeModifier(UUID.fromString("ac7ab816-2b08-46b6-879d-e5dea34ff305"), "artifacts:running_shoes_movement_speed", speedMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isEquippedBy((LivingEntity)event.player)) {
            AttributeInstance movementSpeed = event.player.m_21051_(Attributes.f_22279_);
            AttributeModifier speedBonus = RunningShoesItem.getSpeedBonus();
            if (movementSpeed != null && movementSpeed.m_22109_(speedBonus)) {
                movementSpeed.m_22130_(speedBonus);
                event.player.f_19793_ = 0.6f;
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!ModConfig.server.isCosmetic(this)) {
            LivingEntity entity = slotContext.entity();
            AttributeInstance movementSpeed = entity.m_21051_(Attributes.f_22279_);
            AttributeModifier speedBonus = RunningShoesItem.getSpeedBonus();
            if (entity.m_20142_()) {
                if (!movementSpeed.m_22109_(speedBonus)) {
                    movementSpeed.m_22118_(speedBonus);
                }
                if (entity instanceof Player) {
                    entity.f_19793_ = Math.max(entity.f_19793_, 1.1f);
                }
                if (entity.f_19797_ % 20 == 0) {
                    this.damageStack(slotContext, stack);
                }
            } else if (movementSpeed.m_22109_(speedBonus)) {
                movementSpeed.m_22130_(speedBonus);
                entity.f_19793_ = 0.6f;
            }
        }
    }
}

